/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndItems;
import org.jetbrains.annotations.Nullable;

public class SilkMothEntity
extends Animal
implements FlyingAnimal {
    private BlockPos hivePos;
    private BlockPos entrance;
    private Level hiveWorld;

    public SilkMothEntity(EntityType<? extends SilkMothEntity> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21365_ = new MothLookControl((Mob)this);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.f_21364_ = 1;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22280_, 0.4).m_22268_(Attributes.f_22279_, 0.1);
    }

    public void setHive(Level world, BlockPos hive) {
        this.hivePos = hive;
        this.hiveWorld = world;
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.hivePos != null) {
            tag.m_128365_("HivePos", (Tag)NbtUtils.m_129224_((BlockPos)this.hivePos));
            tag.m_128359_("HiveWorld", this.hiveWorld.m_46472_().m_135782_().toString());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("HivePos")) {
            this.hivePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("HivePos"));
            ResourceLocation worldID = new ResourceLocation(tag.m_128461_("HiveWorld"));
            try {
                this.hiveWorld = this.m_9236_().m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)worldID));
            }
            catch (Exception e) {
                BetterEnd.LOGGER.warning("Silk Moth Hive World {} is missing!", new Object[]{worldID});
                this.hivePos = null;
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ReturnToHiveGoal());
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{EndItems.BLOSSOM_BERRY}), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(8, (Goal)new WanderAroundGoal());
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world){

            public boolean m_6342_(BlockPos pos) {
                BlockState state = this.f_26495_.m_8055_(pos);
                return state.m_60795_() || !state.m_280555_();
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        birdNavigation.m_26440_(false);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26443_(true);
        return birdNavigation;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public boolean m_20068_() {
        return true;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)EndEntities.SILK_MOTH.type().m_20615_((Level)world);
    }

    protected void m_7625_(DamageSource source, boolean causedByPlayer) {
        int minCount = 0;
        int maxCount = 1;
        if (causedByPlayer && this.f_20888_ != null) {
            int looting = EnchantmentHelper.m_44930_((LivingEntity)this.f_20888_);
            minCount += looting;
            if ((maxCount += looting) > 2) {
                maxCount = 2;
            }
        }
        int count = minCount < maxCount ? MHelper.randRange((int)minCount, (int)maxCount, (RandomSource)this.f_19796_) : maxCount;
        ItemEntity drop = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)EndItems.SILK_FIBER, count));
        this.m_9236_().m_7967_((Entity)drop);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_150930_(EndItems.BLOSSOM_BERRY);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        return super.m_6071_(player, interactionHand);
    }

    class MothLookControl
    extends LookControl {
        MothLookControl(Mob entity) {
            super(entity);
        }

        protected boolean m_8106_() {
            return true;
        }
    }

    class ReturnToHiveGoal
    extends Goal {
        ReturnToHiveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return SilkMothEntity.this.hivePos != null && SilkMothEntity.this.hiveWorld == SilkMothEntity.this.m_9236_() && SilkMothEntity.this.f_21344_.m_26571_() && SilkMothEntity.this.f_19796_.m_188503_(8) == 0 && SilkMothEntity.this.m_20182_().m_82531_((double)SilkMothEntity.this.hivePos.m_123341_(), (double)SilkMothEntity.this.hivePos.m_123342_(), (double)SilkMothEntity.this.hivePos.m_123343_()) < 16384.0;
        }

        public boolean m_8045_() {
            return SilkMothEntity.this.f_21344_.m_26572_() && SilkMothEntity.this.m_9236_().m_8055_(SilkMothEntity.this.entrance).m_60795_() && (SilkMothEntity.this.m_9236_().m_8055_(SilkMothEntity.this.hivePos).m_60713_(EndBlocks.SILK_MOTH_NEST) || SilkMothEntity.this.m_9236_().m_8055_(SilkMothEntity.this.hivePos).m_60713_(EndBlocks.SILK_MOTH_HIVE));
        }

        public void m_8056_() {
            BlockState state = SilkMothEntity.this.m_9236_().m_8055_(SilkMothEntity.this.hivePos);
            if (!state.m_60713_(EndBlocks.SILK_MOTH_NEST) && !state.m_60713_(EndBlocks.SILK_MOTH_HIVE)) {
                SilkMothEntity.this.hivePos = null;
                return;
            }
            try {
                SilkMothEntity.this.entrance = SilkMothEntity.this.hivePos.m_121945_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
                SilkMothEntity.this.f_21344_.m_26536_(SilkMothEntity.this.f_21344_.m_7864_(SilkMothEntity.this.entrance, 1), 1.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void m_8037_() {
            double dz;
            double dy;
            super.m_8037_();
            if (SilkMothEntity.this.entrance == null) {
                return;
            }
            double dx = Math.abs((double)SilkMothEntity.this.entrance.m_123341_() - SilkMothEntity.this.m_20185_());
            if (dx + (dy = Math.abs((double)SilkMothEntity.this.entrance.m_123342_() - SilkMothEntity.this.m_20186_())) + (dz = Math.abs((double)SilkMothEntity.this.entrance.m_123343_() - SilkMothEntity.this.m_20189_())) < 1.0) {
                BlockState state = SilkMothEntity.this.m_9236_().m_8055_(SilkMothEntity.this.hivePos);
                if (state.m_60713_(EndBlocks.SILK_MOTH_NEST) || state.m_60713_(EndBlocks.SILK_MOTH_HIVE)) {
                    int fullness = (Integer)state.m_61143_((Property)EndBlockProperties.FULLNESS);
                    boolean isHive = state.m_60713_(EndBlocks.SILK_MOTH_HIVE);
                    if (fullness < 3 && (isHive || SilkMothEntity.this.f_19796_.m_188499_())) {
                        if ((fullness += isHive ? MHelper.randRange((int)1, (int)2, (RandomSource)SilkMothEntity.this.f_19796_) : 1) > 3) {
                            fullness = 3;
                        }
                        BlocksHelper.setWithUpdate((LevelAccessor)SilkMothEntity.this.hiveWorld, (BlockPos)SilkMothEntity.this.hivePos, (BlockState)((BlockState)state.m_61124_((Property)EndBlockProperties.FULLNESS, (Comparable)Integer.valueOf(fullness))));
                    }
                    SilkMothEntity.this.m_9236_().m_5594_(null, SilkMothEntity.this.entrance, SoundEvents.f_11695_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    SilkMothEntity.this.m_146870_();
                } else {
                    SilkMothEntity.this.hivePos = null;
                }
            }
        }
    }

    class WanderAroundGoal
    extends Goal {
        WanderAroundGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return SilkMothEntity.this.f_21344_.m_26571_() && SilkMothEntity.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return SilkMothEntity.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3d = null;
            if (SilkMothEntity.this.hivePos != null && SilkMothEntity.this.hiveWorld == SilkMothEntity.this.m_9236_() && SilkMothEntity.this.m_20182_().m_82531_((double)SilkMothEntity.this.hivePos.m_123341_(), (double)SilkMothEntity.this.hivePos.m_123342_(), (double)SilkMothEntity.this.hivePos.m_123343_()) > 16.0) {
                vec3d = SilkMothEntity.this.m_20182_().m_82520_(SilkMothEntity.this.f_19796_.m_188583_() * 2.0, 0.0, SilkMothEntity.this.f_19796_.m_188583_() * 2.0);
            }
            Vec3 vec3 = vec3d = vec3d == null ? this.getRandomLocation() : vec3d;
            if (vec3d != null) {
                try {
                    SilkMothEntity.this.f_21344_.m_26536_(SilkMothEntity.this.f_21344_.m_7864_(new BlockPos((int)vec3d.f_82479_, (int)vec3d.f_82480_, (int)vec3d.f_82481_), 1), 1.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vec3d3 = SilkMothEntity.this.m_20252_(0.0f);
            Vec3 vec3d4 = HoverRandomPos.m_148465_((PathfinderMob)SilkMothEntity.this, (int)8, (int)7, (double)vec3d3.f_82479_, (double)vec3d3.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec3d4 != null ? vec3d4 : AirAndWaterRandomPos.m_148357_((PathfinderMob)SilkMothEntity.this, (int)8, (int)4, (int)-2, (double)vec3d3.f_82479_, (double)vec3d3.f_82481_, (double)1.5707963705062866);
        }
    }
}

